function [xk,fxk] = gradientenverfahren(f,x0,tol)

    xk = x0;
    
    % numerischen Gradienten bestimmen:
    for i = 1:length(x0)
    
        xkp = xk;
        xkp(i) = xk(i)*(1+sqrt(eps));
        gk(i) = (f(xkp)-f(xk))/(xk(i)*sqrt(eps));

    end

    while gk*gk' > tol^2
        
        
        dk = -gk'; 
        tE = schrittweite(xk,dk);                                          % exakte Schrittweite ermitteln
        xk = xk + tE*dk;                                                   % Iterationsschritt
 
        % numerischen Gradienten bestimmen:
        for i = 1:length(x0)
    
            xkp = xk;
            xkp(i) = xk(i)*(1+sqrt(eps));
            gk(i) = (f(xkp)-f(xk))/(xk(i)*sqrt(eps));

        end       
        
    end
    
    fxk = f(xk);

end